/*****************************************************
définition des différentes grandeurs et initialisation
*****************************************************/

#define analogPin 0     // définition de la broche de mesure de uC
#define chargePin 8    // définition de la broche permettant la charge ou décharge du condensateur

unsigned long Instantlnitial ; 
unsigned long Tau ;           // Tau = Temps Caractéristique en microsecondes (µs)
float C ;                     // C = Capacité en nanofarad (nF)

void setup(){ 
  pinMode(chargePin,OUTPUT) ; 
  digitalWrite(chargePin,LOW) ;
  Serial.begin(9600) ;
}

/**********************************
 Mesure et affichage de la capacité
**********************************/

void loop(){
  digitalWrite(chargePin,HIGH) ; 
  Instantlnitial = micros() ;
  while(analogRead(analogPin) < 647) {
    } 
  Tau = micros() - Instantlnitial ;
  C = (Tau*1000.0/1000000.0);
  Serial.print("C =") ;
  Serial.print(C) ;
  Serial.println(" nF") ;
  digitalWrite(chargePin,LOW) ;
  while(analogRead(analogPin) > 0){
    }
  
/***********************
Pause entre deux mesures
***********************/

  delay(1000) ;    // le programme attend 1000 ms avant de poursuivre
}
